<?php
	
add_action( 'wp_enqueue_scripts', 'dsa_enqueue_scripts_styles' );

function dsa_enqueue_scripts_styles() {
    $parenthandle = 'divi-style'; 
    $theme = wp_get_theme();
    wp_enqueue_style( $parenthandle, get_template_directory_uri() . '/style.css', 
        array(),
        $theme->parent()->get('Version')
    );
    wp_enqueue_style( 'maya-style', get_stylesheet_uri(),
        array( $parenthandle ),
        $theme->get('Version')
    );
    
    
    // Load Custom Script File
    wp_enqueue_script( 'maya-scripts', get_stylesheet_directory_uri() . '/js/scripts.js',
    	array( 'jquery' ),
    	1.1,
    	true
    );
}


// Allow SVG Uploads

function dsa_allow_svgimg_types($mimes) {
	  $mimes['svg'] = 'image/svg+xml';
	  return $mimes;
	}
add_filter('upload_mimes', 'dsa_allow_svgimg_types');


function dsa_check_svgimg_types($dsa_svg_filetype_ext_data, $file, $filename, $mimes) {
	if ( substr($filename, -4) === '.svg' ) {
		$dsa_svg_filetype_ext_data['ext'] = 'svg';
		$dsa_svg_filetype_ext_data['type'] = 'image/svg+xml';
	}
	return $dsa_svg_filetype_ext_data;
}
add_filter( 'wp_check_filetype_and_ext', 'dsa_check_svgimg_types', 100, 4 );